/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper.gateway;

import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.util.Event;
import jade.util.Logger;
import jade.util.leap.Properties;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;

public class JadeGateway {
    private static ContainerController myContainer = null;
    private static AgentController myAgent = null;
    private static String agentType;
    private static ProfileImpl profile;
    private static Properties jadeProps;
    private static final Logger myLogger;
    static /* synthetic */ Class class$jade$wrapper$gateway$JadeGateway;
    static /* synthetic */ Class class$jade$wrapper$gateway$GatewayAgent;

    public static final String getProfileProperty(String key, String defaultValue) {
        return profile.getParameter(key, defaultValue);
    }

    public static final void execute(Object command) throws StaleProxyException, ControllerException, InterruptedException {
        JadeGateway.execute(command, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void execute(Object command, long timeout) throws StaleProxyException, ControllerException, InterruptedException {
        Event e = null;
        Class clazz = class$jade$wrapper$gateway$JadeGateway == null ? (class$jade$wrapper$gateway$JadeGateway = JadeGateway.class$("jade.wrapper.gateway.JadeGateway")) : class$jade$wrapper$gateway$JadeGateway;
        synchronized (clazz) {
            JadeGateway.checkJADE();
            e = new Event(-1, command);
            try {
                if (myLogger.isLoggable(Logger.INFO)) {
                    myLogger.log(Logger.INFO, "Requesting execution of command " + command);
                }
                myAgent.putO2AObject(e, false);
            }
            catch (StaleProxyException exc) {
                exc.printStackTrace();
                JadeGateway.restartJADE();
                myAgent.putO2AObject(e, false);
            }
        }
        e.waitUntilProcessed(timeout);
    }

    public static final void checkJADE() throws StaleProxyException, ControllerException {
        if (myContainer == null && (myContainer = Runtime.instance().createAgentContainer(profile)) == null) {
            throw new ControllerException("JADE startup failed.");
        }
        if (myAgent == null) {
            myAgent = myContainer.createNewAgent("Control" + myContainer.getContainerName(), agentType, null);
            myAgent.start();
        }
    }

    private static final void restartJADE() throws StaleProxyException, ControllerException {
        JadeGateway.shutdown();
        JadeGateway.init(agentType, jadeProps);
        JadeGateway.checkJADE();
    }

    public static final void init(String agentClassName, Properties jadeProfile) {
        agentType = agentClassName;
        if (agentType == null) {
            agentType = (class$jade$wrapper$gateway$GatewayAgent == null ? (class$jade$wrapper$gateway$GatewayAgent = JadeGateway.class$("jade.wrapper.gateway.GatewayAgent")) : class$jade$wrapper$gateway$GatewayAgent).getName();
        }
        if ((jadeProps = jadeProfile) != null) {
            jadeProps.setProperty("main", "false");
        }
        profile = jadeProfile == null ? new ProfileImpl(false) : new ProfileImpl(jadeProfile);
    }

    public static final void shutdown() {
        try {
            if (myAgent != null) {
                myAgent.kill();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (myContainer != null) {
                myContainer.kill();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        myAgent = null;
        myContainer = null;
    }

    private JadeGateway() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        myLogger = Logger.getMyLogger((class$jade$wrapper$gateway$JadeGateway == null ? (class$jade$wrapper$gateway$JadeGateway = JadeGateway.class$("jade.wrapper.gateway.JadeGateway")) : class$jade$wrapper$gateway$JadeGateway).getName());
    }
}

